/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNextNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNextNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.interop.JSIteratorWrapper;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSIteratorWrapper.class)
final class JSIteratorWrapperGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JSIteratorWrapperGen() {
    }

    static {
        LibraryExport.register(JSIteratorWrapper.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSIteratorWrapper.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet((LibraryFactory)JSIteratorWrapperGen.access$100(), (String[])new String[]{"isIterator", "hasIteratorNextElement", "getIteratorNextElement"});

        private InteropLibraryExports() {
            super(InteropLibrary.class, JSIteratorWrapper.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSIteratorWrapper);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Uncached());
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSIteratorWrapper);
            return (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=JSIteratorWrapper.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JSIteratorWrapper)receiver_).iterator;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSIteratorWrapper) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSIteratorWrapper;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isIterator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSIteratorWrapper)receiver).isIterator();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasIteratorNextElement(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                return arg0Value.hasIteratorNextElement((JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropGetIteratorNextNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object getIteratorNextElement(Object arg0Value_) throws StopIterationException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                return arg0Value.getIteratorNextElement((JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropGetIteratorNextNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=JSIteratorWrapper.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverIteratorInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private JSInteropGetIteratorNextNode getIteratorNext;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;

            protected Cached(Object receiver) {
                JSIteratorWrapper castReceiver = (JSIteratorWrapper)receiver;
                this.receiverIteratorInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create((Object)castReceiver.iterator));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JSIteratorWrapper)receiver_).iterator;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverIteratorInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSIteratorWrapper) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof JSIteratorWrapper)) {
                    return false;
                }
                return this.receiverIteratorInteropLibrary_.accepts((Object)((JSIteratorWrapper)receiver).iterator);
            }

            public boolean isIterator(Object receiver) {
                assert (receiver instanceof JSIteratorWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSIteratorWrapper)receiver).isIterator();
            }

            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert (arg0Value_ instanceof JSIteratorWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage hasIteratorNextElementNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm hasIteratorNextElementNode__realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                    return arg0Value.hasIteratorNextElement(hasIteratorNextElementNode__language__, hasIteratorNextElementNode__realm__, this.getIteratorNext);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasIteratorNextElementNode_AndSpecialize(JSIteratorWrapper arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JSRealm hasIteratorNextElementNode__realm__ = null;
                    JavaScriptLanguage hasIteratorNextElementNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    hasIteratorNextElementNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    hasIteratorNextElementNode__realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
                    if (this.getIteratorNext == null) {
                        this.getIteratorNext = (JSInteropGetIteratorNextNode)super.insert((Node)JSInteropGetIteratorNextNode.create());
                    }
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.hasIteratorNextElement(hasIteratorNextElementNode__language__, hasIteratorNextElementNode__realm__, this.getIteratorNext);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                assert (arg0Value_ instanceof JSIteratorWrapper) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSIteratorWrapper arg0Value = (JSIteratorWrapper)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage getIteratorNextElementNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm getIteratorNextElementNode__realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                    return arg0Value.getIteratorNextElement(getIteratorNextElementNode__language__, getIteratorNextElementNode__realm__, this.getIteratorNext);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getIteratorNextElementNode_AndSpecialize(JSIteratorWrapper arg0Value) throws StopIterationException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JSRealm getIteratorNextElementNode__realm__ = null;
                    JavaScriptLanguage getIteratorNextElementNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    getIteratorNextElementNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    getIteratorNextElementNode__realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
                    if (this.getIteratorNext == null) {
                        this.getIteratorNext = (JSInteropGetIteratorNextNode)super.insert((Node)JSInteropGetIteratorNextNode.create());
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.getIteratorNextElement(getIteratorNextElementNode__language__, getIteratorNextElementNode__realm__, this.getIteratorNext);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

